/// @description GUI
if (instance_exists(oPlayerStats))
{
	var message = "Press F5 to reset the game";
	var fuel = clamp(round((oPlayerStats.currentFuel / oPlayerStats.maxFuel) * 100), 0, 100);
	var heat = clamp(round((oPlayerStats.currentWeaponHeat / oPlayerStats.maxWeaponHeat) * 100), 0, 100);
	var cool = (oPlayerStats.maxWeaponHeat - oPlayerStats.heatingSpeed) - oPlayerStats.currentWeaponHeat;
	var almostCool = (oPlayerStats.maxWeaponHeat - oPlayerStats.heatingSpeed) - oPlayerStats.currentWeaponHeat + oPlayerStats.coolingSpeed*10;
	
	// draw outline for the bars
	draw_set_color(c_black)
	//		for fuelbar
	draw_rectangle(
		fuelBarX - fuelBarWidth, fuelBarY - 1,	// top-left corner
		fuelBarX + fuelBarWidth + 1, fuelBarY + fuelBarHeight + 1,	// bottom-right corner
		false);
	//		for heatbar
	draw_rectangle(
		heatBarX - heatBarWidth, heatBarY - 1,	// top-left corner
		heatBarX + heatBarWidth + 1, heatBarY + heatBarHeight + 1,	// bottom-right corner
		false);
	
	// draw the colored bars
	draw_set_color(c_white);
	
	// draw fuel bar
	draw_healthbar(
		fuelBarX, fuelBarY,									// top-left corner
		fuelBarX + fuelBarWidth, fuelBarY + fuelBarHeight,	// bottom-right corner
		fuel,
		c_black,	// background color
		c_red,		// min color
		c_yellow,	// max color
		dir.right,	// direction
		false,		// no background
		false,		// no border
	);
	draw_healthbar(
		fuelBarX, fuelBarY,									// top-left corner
		fuelBarX - fuelBarWidth, fuelBarY + fuelBarHeight,	// bottom-right corner
		fuel,
		c_black,	// background color
		c_red,		// min color
		c_yellow,	// max color
		dir.left,	// direction
		false,		// no background
		false,		// no border
	);
	
	// draw heat bar
	draw_healthbar(
		heatBarX,  heatBarY,								// top-left corner
		heatBarX + heatBarWidth, heatBarY + heatBarHeight,	// bottom-right corner
		heat,
		c_black,	// background color
		cool ? c_aqua : (almostCool ? c_yellow : c_red),	// min color
		cool ? c_aqua : (almostCool ? c_yellow : c_red),	// max color
		dir.right,	// direction
		false,		// no background
		false,		// no border
	);
	draw_healthbar(
		heatBarX,  heatBarY,								// top-left corner
		heatBarX - heatBarWidth, heatBarY + heatBarHeight,	// bottom-right corner
		heat,
		c_black,	// background color
		cool ? c_aqua : (almostCool ? c_yellow : c_red),	// min color
		cool ? c_aqua : (almostCool ? c_yellow : c_red),	// max color
		dir.left,	// direction
		false,		// no background
		false,		// no border
	);
	
	// Draw the text
	DrawTextWithOutline(fuelBarX + 2, fuelBarY + fuelBarHeight - 11, string(fuel) + "%");
	DrawTextWithOutline(heatBarX + 2, heatBarY + heatBarHeight - 11, string(heat) + "%");
	
	// Show death message
	if (!instance_exists(oPlayer)) {
		if (room != credits) {
			DrawTextWithOutline(width / 2, height / 2 - 20, "MISSION FAILED", c_red)
		} else {
			DrawTextWithOutline(width / 2, height / 2 - 20, "MISSION COMPLETE", c_green);
			DrawTextWithOutline(width / 2, height / 2 + 16, "Press ESCAPE to exit game");
		}
		DrawTextWithOutline(width / 2, height / 2, message);
	}
	
	// Draw the batteries
	draw_sprite_ext(sBattery, (oPlayerStats.currentBatteries > 0 ? 1 : 0), heatBarX - 18, heatBarY+8, 1, 1, 0, c_white, 1);
	draw_sprite_ext(sBattery, (oPlayerStats.currentBatteries > 1 ? 1 : 0), heatBarX + 6,  heatBarY+8, 1, 1, 0, c_white, 1);
	
	// Draw the energy cell if we have it
	if (oPlayerStats.energyCell) {
		energyCell_frame = energyCell_frame + .25;
		draw_sprite(sEnergyCell_GUI, round(energyCell_frame), energyCellX - 132, energyCellY);
		if energyCell_frame > 11.4 then energyCell_frame = -0.5;
		
		DrawTextWithOutline(energyCellX + 16, energyCellY - 8, energyCellMessage);
	}
	
	// is paused?
	if (oGameController.state == gameState.paused or 
		oGameController.state == gameState.waiting) {
		var original_color = draw_get_color();
		if (original_color != c_black)
			draw_set_color(c_black);
		draw_set_alpha(0.82);
		draw_rectangle(0, 0, width, height, false);
		draw_set_alpha(1.0);
		
		var xX = width  / 2;
		var yY = height / 2;
		
		if (oGameController.state == gameState.paused) {
			DrawTextWithOutline(xX, yY, "GAME PAUSED\nPress ENTER to resume");
		} else {
			// Draw the sacrifice menu
			if (oPlayerStats.selectedSacrifice == noone) {
				// no more sacrifices to make
				DrawTextWithOutline(xX, yY - 100, 
					"The only thing left to sacrifice\nyour own battery.\n\nWill you do it?\n\n\nPress SPACE to accept"
				)
			} else {
			
				DrawTextWithOutline(xX, yY - 100, 
					"You have to sacrifice one of your\n" +
					"parts to hack this console.\n" +
					"Please choose wisely."
				)
			
				var options = [
					oPlayerStats.weaponCooling,
					oPlayerStats.currentBatteries > 0,
					oPlayerStats.jetpack
				];
			
				draw_set_color(c_ltgray);
				switch (oPlayerStats.selectedSacrifice)
				{
				    case 0:
						draw_rectangle( 81, 100, 141, 164, false);
						break;
				    case 1:
						draw_rectangle(200, 100, 280, 164, false);
						break;
				    case 2:
						draw_rectangle(338, 100, 398, 164, false);
						break;
				}
			
				draw_sprite(sGunLarge,	   (options[0]?0:1), xX-128, 150);
				DrawTextWithOutline(xX-128,	yY + 32, "Sacrifice\nweapon cooling\n(slow firerate)",			(options[0]?c_white:c_dkgray));
				draw_sprite(sBatteryLarge, (options[1]?0:1), xX,	 161);
				DrawTextWithOutline(xX,		yY + 32, "Sacrifice\nspare battery\n(lose a life)",				(options[1]?c_white:c_dkgray));
				draw_sprite(sJetpackLarge, (options[2]?0:1), xX+128, 145);
				DrawTextWithOutline(xX+128,	yY + 32, "Sacrifice\njetpack controller\n(can't fly anymore)",	(options[2]?c_white:c_dkgray));
			}
		
		}
		if (original_color != c_black)
			draw_set_color(original_color);
	}
	
}

if (instance_exists(oPlayer) and room == main_menu) {
	draw_set_halign(fa_left);
	DrawTextWithOutline(16, 200, "ARROW KEYS for movement\nSPACE for shooting\nHOLD UP ARROW to fly");
	draw_set_halign(fa_right);
	DrawTextWithOutline(width - 16, 220, "ENTER to pause the game\nESCAPE to exit the game");
	draw_set_halign(fa_center);
	DrawTextWithOutline(240, 50, "Kill this little slimy fellow to start the game.");
}

if (room == credits and oGameController.state = gameState.credits and instance_exists(oPlayer)) {
	DrawTextWithOutline(width / 2, height / 2 - 20, "MISSION COMPLETE", c_green);
	DrawTextWithOutline(width / 2, height / 2 + 16, "Press ESCAPE to exit game");
}









